function TES=matrix(sys)
% MATRIX retourne la matrice de transfert pour le systme 
% {nergie potentielle-objet physique}.
%   TES=matrix(sys)
%       >> sys = Energie potentielle-objet physique
%       << TES = Matrice de transfert (2*2) entre les plans
%                d'entre E et de sortie S.
%
% Olivier Pujol : septembre 2013
%
if (nargin~=1), error('Mauvais nombre d''argument d''entre!');end
%
nE=size(sys,2);     % Nombre de valeurs de l'nergie = nombre de systme
TES=cell(1,nE);     % Initialisation de la matrice de transfert
%
for iE=1:length(sys)
    TES{iE}=matrix(sys{iE}{2});
    for n=3:length(sys{iE})
        TES{iE}=translation(sys{iE}{n-1},sys{iE}{n})*TES{iE};
        TES{iE}=matrix(sys{iE}{n})*TES{iE};
    end
end
%
return;